# Carpool Starter (PHP + MySQL)

A minimal car pooling app for office vehicle pooling.

## Features
- Users submit vehicle requests (type: MPV_MID, MPV_ECO, SUV_ECO), pickup/drop via coordinates/POI, passenger name, org unit.
- Auto-assign finds an available (paired) driver + vehicle for the time window.
- Drivers accept/decline, start/finish trip (GPS captured from browser).
- Admin CRUD: vehicles, drivers, driver–vehicle pairing (with period).
- Basic role-based login (user/driver/admin).

## Quick Start
1. Create a MySQL database, e.g. `carpool`.
2. Import schema & seed:
   ```bash
   mysql -u root -p carpool < sql/schema.sql
   mysql -u root -p carpool < sql/seed.sql
   ```
3. Update database credentials in `config/db.php`.
4. Serve `/public` via PHP (Apache/Nginx). For quick test:
   ```bash
   php -S 0.0.0.0:8080 -t public
   ```

## Default Accounts (first-time login)
- **Admin**: `admin@example.com` / `Admin123!`
- **Driver**: `driver@example.com` / `Driver123!`
- **User**: `user@example.com` / `User123!`

> On first successful login, passwords with `TEMP:` in DB are automatically upgraded to secure hashes.

## Pages
- `/public/index.php` – Login / role router
- `/public/request_new.php` – User creates a request
- `/public/my_requests.php` – User sees own requests + assignment (driver & plate)
- `/public/driver_jobs.php` – Driver jobs list (accept/start/finish)
- `/public/dashboard.php` – Admin dashboard + auto-assign PENDING requests
- `/public/admin_master.php` – Admin CRUD (vehicles, drivers, pairings)

## API Endpoints (subset)
- `api/auth_login.php`
- `api/requests_create.php`
- `api/assign_auto.php`
- `api/driver_accept.php`, `api/driver_decline.php`
- `api/trip_start.php`, `api/trip_finish.php`
- `api/master_vehicle_crud.php`, `api/master_driver_crud.php`, `api/master_pairing_crud.php`

## Notes
- Coordinates stored as DECIMAL; you can later move to MySQL POINT + spatial index.
- Auto-assign uses a 30-min buffer before pickup and 120-min after pickup (tweak in `api/assign_auto.php`).
- Secure with HTTPS in production. Add CSRF, rate limits, and ACLs per your policy.
