<?php
header('Content-Type: application/json');
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../config/auth.php';
require_login(); require_role(['admin']);

$requestId = intval($_POST['request_id'] ?? 0);
if (!$requestId) { http_response_code(400); echo json_encode(['ok'=>false,'error'=>'missing request_id']); exit; }

$req = $pdo->prepare("SELECT * FROM ride_requests WHERE id=? AND status='PENDING'");
$req->execute([$requestId]);
$r = $req->fetch();
if (!$r) { http_response_code(404); echo json_encode(['ok'=>false,'error'=>'request not found or already assigned']); exit; }

$pickup = new DateTime($r['pickup_time']);
$start  = clone $pickup; $start->modify('-30 minutes');
$end    = clone $pickup; $end->modify('+120 minutes');

$sql = "
SELECT p.id pairing_id, d.id driver_id, v.id vehicle_id, v.plate_no
FROM driver_vehicle_pairings p
JOIN drivers d ON d.id=p.driver_id AND d.is_active=1
JOIN vehicles v ON v.id=p.vehicle_id AND v.is_active=1 AND v.type=?
WHERE (p.start_date <= ?) AND (p.end_date IS NULL OR p.end_date >= ?)
ORDER BY p.is_primary DESC, v.plate_no ASC
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$r['vehicle_type'], $pickup->format('Y-m-d'), $pickup->format('Y-m-d')]);
$candidates = $stmt->fetchAll();

$hasConflict = $pdo->prepare("
SELECT count(*) c FROM trips
WHERE (driver_id=? OR vehicle_id=?)
AND status IN ('NOT_STARTED','ONGOING')
AND (
      (start_time IS NOT NULL AND start_time BETWEEN ? AND ?)
   OR (finish_time IS NOT NULL AND finish_time BETWEEN ? AND ?)
   OR (start_time IS NULL AND finish_time IS NULL AND ? BETWEEN ? AND ?)
)");

foreach ($candidates as $c) {
  $params = [
    $c['driver_id'], $c['vehicle_id'],
    $start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s'),
    $start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s'),
    $pickup->format('Y-m-d H:i:s'), $start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')
  ];
  $hasConflict->execute($params);
  $cnt = (int) $hasConflict->fetchColumn();
  if ($cnt === 0) {
    $pdo->beginTransaction();
    $ins = $pdo->prepare("INSERT INTO ride_assignments (ride_request_id, driver_id, vehicle_id, assigned_by) VALUES (?,?,?,?)");
    $ins->execute([$r['id'], $c['driver_id'], $c['vehicle_id'], user()['id']]);
    $pdo->prepare("UPDATE ride_requests SET status='ASSIGNED' WHERE id=?")->execute([$r['id']]);
    $pdo->prepare("INSERT INTO trips (ride_request_id, driver_id, vehicle_id) VALUES (?,?,?)")
        ->execute([$r['id'], $c['driver_id'], $c['vehicle_id']]);
    $pdo->commit();
    echo json_encode(['ok'=>true,'assigned'=>['driver_id'=>$c['driver_id'],'vehicle_id'=>$c['vehicle_id'],'plate_no'=>$c['plate_no']]]);
    exit;
  }
}
echo json_encode(['ok'=>false,'error'=>'no available driver/vehicle']);
