<?php
// POST email, password
if ($_SERVER['REQUEST_METHOD']!=='POST') { http_response_code(405); exit; }
$email = trim($_POST['email'] ?? '');
$pass  = $_POST['password'] ?? '';
if (!$email || !$pass) { header('Location: /index.php'); exit; }

$stmt = $pdo->prepare("SELECT * FROM users WHERE email=? AND is_active=1");
$stmt->execute([$email]);
$u = $stmt->fetch();
if (!$u) { header('Location: /index.php'); exit; }

$hash = $u['password_hash'];
$ok = false;
if (strpos($hash,'TEMP:')===0) {
  $temp = substr($hash,5);
  if ($temp === $pass) {
    // upgrade to secure hash
    $new = password_hash($pass, PASSWORD_DEFAULT);
    $pdo->prepare("UPDATE users SET password_hash=? WHERE id=?")->execute([$new,$u['id']]);
    $ok = true;
  }
} else {
  $ok = password_verify($pass, $hash);
}

if ($ok) {
  $_SESSION['uid'] = $u['id'];
  $_SESSION['role'] = $u['role'];
  $_SESSION['org_unit_id'] = $u['org_unit_id'];
  $_SESSION['full_name'] = $u['full_name'];
  if ($u['role']==='admin') header('Location: /dashboard.php');
  elseif ($u['role']==='driver') header('Location: /driver_jobs.php');
  else header('Location: /request_new.php');
  exit;
}
header('Location: /index.php'); exit;
