<?php
require __DIR__.'/../config/db.php';
require __DIR__.'/../config/auth.php';
require_login(); require_role(['admin']);
$vehicles = $pdo->query("SELECT * FROM vehicles ORDER BY id DESC")->fetchAll();
$drivers  = $pdo->query("SELECT d.id, u.full_name, u.email, d.phone, d.license_no
                         FROM drivers d JOIN users u ON u.id=d.user_id ORDER BY d.id DESC")->fetchAll();
$pairings = $pdo->query("
SELECT p.id, u.full_name driver_name, v.plate_no, p.start_date, p.end_date, p.is_primary
FROM driver_vehicle_pairings p
JOIN drivers d ON d.id=p.driver_id
JOIN users u ON u.id=d.user_id
JOIN vehicles v ON v.id=p.vehicle_id
ORDER BY p.id DESC")->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Master Data</title>
<link rel="stylesheet" href="/assets/style.css">
</head><body>
<header><h2>Master Data</h2><nav><a href="/dashboard.php">Dashboard</a></nav></header>

<div class="card">
  <h3>Tambah Kendaraan</h3>
  <form method="post" action="/api/master_vehicle_crud.php">
    <input type="hidden" name="action" value="add">
    <label>Plate No</label><input name="plate_no" required>
    <label>Label</label><input name="label">
    <label>Type</label>
    <select name="type"><option>MPV_MID</option><option>MPV_ECO</option><option>SUV_ECO</option></select>
    <label>Seats</label><input name="seats" value="7">
    <button>Simpan</button>
  </form>
  <table class="table">
    <tr><th>ID</th><th>Plate</th><th>Label</th><th>Type</th><th>Seats</th><th>Active</th></tr>
    <?php foreach($vehicles as $v): ?>
      <tr><td><?= $v['id'] ?></td><td><?= htmlspecialchars($v['plate_no']) ?></td><td><?= htmlspecialchars($v['label']) ?></td>
      <td><?= $v['type'] ?></td><td><?= $v['seats'] ?></td><td><?= $v['is_active'] ?></td></tr>
    <?php endforeach; ?>
  </table>
</div>

<div class="card">
  <h3>Tambah Driver</h3>
  <form method="post" action="/api/master_driver_crud.php">
    <input type="hidden" name="action" value="add_by_email">
    <label>Nama Lengkap</label><input name="full_name" required>
    <label>Email</label><input type="email" name="email" required>
    <label>Phone</label><input name="phone">
    <label>License No</label><input name="license_no">
    <button>Simpan</button>
  </form>
  <table class="table">
    <tr><th>ID</th><th>Driver</th><th>Email</th><th>Phone</th><th>SIM</th></tr>
    <?php foreach($drivers as $d): ?>
      <tr><td><?= $d['id'] ?></td><td><?= htmlspecialchars($d['full_name']) ?></td><td><?= htmlspecialchars($d['email']) ?></td>
      <td><?= htmlspecialchars($d['phone']) ?></td><td><?= htmlspecialchars($d['license_no']) ?></td></tr>
    <?php endforeach; ?>
  </table>
</div>

<div class="card">
  <h3>Pairing Driver-Kendaraan</h3>
  <form method="post" action="/api/master_pairing_crud.php">
    <input type="hidden" name="action" value="add">
    <label>Driver ID</label><input name="driver_id" required>
    <label>Vehicle ID</label><input name="vehicle_id" required>
    <label>Start Date</label><input type="date" name="start_date" required>
    <label>End Date</label><input type="date" name="end_date">
    <label>Primary?</label>
    <select name="is_primary"><option value="1">Yes</option><option value="0">No</option></select>
    <button>Simpan</button>
  </form>
  <table class="table">
    <tr><th>ID</th><th>Driver</th><th>Plate</th><th>Start</th><th>End</th><th>Primary</th></tr>
    <?php foreach($pairings as $p): ?>
      <tr><td><?= $p['id'] ?></td><td><?= htmlspecialchars($p['driver_name']) ?></td>
      <td><?= htmlspecialchars($p['plate_no']) ?></td><td><?= $p['start_date'] ?></td><td><?= $p['end_date'] ?></td>
      <td><?= $p['is_primary'] ?></td></tr>
    <?php endforeach; ?>
  </table>
</div>
</body></html>
