<?php
require __DIR__.'/../config/db.php';
require __DIR__.'/../config/auth.php';
require_login();
$u = user();
$uid = (int)$u['id'];
$rows = $pdo->query("
SELECT r.*, a.driver_id, v.plate_no, u2.full_name driver_name
FROM ride_requests r
LEFT JOIN ride_assignments a ON a.ride_request_id=r.id
LEFT JOIN drivers d ON d.id=a.driver_id
LEFT JOIN users u2 ON u2.id=d.user_id
LEFT JOIN vehicles v ON v.id=a.vehicle_id
WHERE r.requester_id={$uid}
ORDER BY r.created_at DESC")->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Request Saya</title>
<link rel="stylesheet" href="/assets/style.css">
</head><body>
<header>
  <h2>Request Saya</h2>
  <nav>
    <a href="/request_new.php">Buat Request</a>
  </nav>
</header>
<div class="card">
  <table class="table">
    <tr><th>ID</th><th>Type</th><th>Pickup</th><th>Status</th><th>Driver</th><th>Plate</th></tr>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= $r['id'] ?></td>
        <td><?= $r['vehicle_type'] ?></td>
        <td><?= $r['pickup_time'] ?></td>
        <td><?= $r['status'] ?></td>
        <td><?= htmlspecialchars($r['driver_name'] ?? '-') ?></td>
        <td><?= htmlspecialchars($r['plate_no'] ?? '-') ?></td>
      </tr>
    <?php endforeach; ?>
  </table>
</div>
</body></html>
